function nicepng(filename)
% nicepng(filename)
% 
% Creates a high resolution PNG file for the current figure. First the
% image is exported to EPS, imagemagick is used to convert the EPS to PNG.
% This works better than Matlab's build in figure exporting features. This
% function requires ImageMagick to be installed properly, with it's path
% added to windows search path.
% 
% Yannick Kremer


h = gcf;
print(h ,'-depsc2', [filename, '.eps']);
system( ['convert -density 300 ', filename, '.eps ', filename, '.png'] );

% Save a copy in Matlab function, just in case (you'll thank me later :) )
saveas(h, [filename, '.fig']);